
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, name="vitamin_B7")  # milligrams of vitamin B7
    x1 = m.addVar(lb=0, name="vitamin_B5")  # milligrams of vitamin B5


    # Set objective function
    m.setObjective(8*x0 + 8*x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 6*x1 >= 15, "muscle_growth")
    m.addConstr(3*x0 + 3*x1 >= 21, "cardiovascular_support")
    m.addConstr(8*x0 + 1*x1 >= 9, "immune_support")
    m.addConstr(4*x0 + 5*x1 >= 25, "energy_stability")
    m.addConstr(2*x0 + 2*x1 >= 15, "kidney_support")
    m.addConstr(-3*x0 + 8*x1 >= 0, "custom_constraint_1")
    m.addConstr(6*x0 + 6*x1 <= 24, "muscle_growth_upper")
    m.addConstr(3*x0 + 3*x1 <= 25, "cardiovascular_support_upper")
    m.addConstr(8*x0 + 1*x1 <= 12, "immune_support_upper")
    m.addConstr(4*x0 + 5*x1 <= 35, "energy_stability_upper")
    m.addConstr(2*x0 + 2*x1 <= 24, "kidney_support_upper")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Optimal objective: %g' % m.objVal)
        print('vitamin_B7:', x0.x)
        print('vitamin_B5:', x1.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
