
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B7
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B5

    # Define the objective function
    model.setObjective(8 * x1 + 8 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(6 * x1 <= 39)
    model.addConstr(3 * x1 <= 42)
    model.addConstr(8 * x1 <= 18)
    model.addConstr(4 * x1 <= 65)
    model.addConstr(2 * x1 <= 39)
    model.addConstr(6 * x2 <= 39)
    model.addConstr(3 * x2 <= 42)
    model.addConstr(x2 <= 18)
    model.addConstr(5 * x2 <= 65)
    model.addConstr(2 * x2 <= 39)
    model.addConstr(6 * x1 + 6 * x2 >= 15)
    model.addConstr(3 * x1 + 3 * x2 >= 21)
    model.addConstr(8 * x1 + x2 >= 9)
    model.addConstr(4 * x1 + 5 * x2 >= 25)
    model.addConstr(2 * x1 + 2 * x2 >= 15)
    model.addConstr(-3 * x1 + 8 * x2 >= 0)
    model.addConstr(6 * x1 + 6 * x2 <= 24)
    model.addConstr(3 * x1 + 3 * x2 <= 25)
    model.addConstr(8 * x1 + x2 <= 12)
    model.addConstr(4 * x1 + 5 * x2 <= 35)
    model.addConstr(2 * x1 + 2 * x2 <= 24)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B7: {x1.varValue}")
        print(f"Milligrams of vitamin B5: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
