
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cornichons = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cornichons")
apples = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apples")
rotisserie_chickens = m.addVar(lb=0, vtype=GRB.INTEGER, name="rotisserie_chickens")

# Set objective function
m.setObjective(9.55 * cornichons + 6.3 * apples + 2.65 * rotisserie_chickens, GRB.MINIMIZE)

# Add constraints
m.addConstr(3 * apples + 3 * rotisserie_chickens >= 47, "iron_constraint1")
m.addConstr(3 * cornichons + 3 * rotisserie_chickens >= 46, "iron_constraint2")
m.addConstr(3 * cornichons + 1 * apples + 3 * rotisserie_chickens >= 46, "iron_constraint3")
m.addConstr(6 * cornichons + 6 * apples >= 51, "umami_constraint1")
m.addConstr(6 * cornichons + 6 * apples + 7 * rotisserie_chickens >= 43, "umami_constraint2")
m.addConstr(4 * cornichons - 8 * rotisserie_chickens >= 0, "constraint1")
m.addConstr(1 * apples + 3 * rotisserie_chickens <= 50, "constraint2")
m.addConstr(3 * cornichons + 1 * apples <= 64, "constraint3")
m.addConstr(6 * cornichons + 6 * apples <= 144, "constraint4")
m.addConstr(6 * cornichons + 7 * rotisserie_chickens <= 100, "constraint5")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('cornichons:', cornichons.x)
    print('apples:', apples.x)
    print('rotisserie_chickens:', rotisserie_chickens.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

