
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="cornichons", lb=0)
    x1 = model.addVar(name="apples", lb=0)
    x2 = model.addVar(name="rotisserie_chickens", lb=0, integrality=gurobi.GRB.INTEGER)

    # Set the objective function
    model.setObjective(9.55 * x0 + 6.3 * x1 + 2.65 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x0 + x1 + 3 * x2 <= 143)
    model.addConstr(6 * x0 + 6 * x1 + 7 * x2 <= 175)
    model.addConstr(x1 + 3 * x2 >= 47)
    model.addConstr(3 * x0 + 3 * x2 >= 46)
    model.addConstr(3 * x0 + x1 + 3 * x2 >= 46)
    model.addConstr(6 * x0 + 6 * x1 >= 51)
    model.addConstr(6 * x0 + 6 * x1 + 7 * x2 >= 43)
    model.addConstr(4 * x0 - 8 * x2 >= 0)
    model.addConstr(x1 + 3 * x2 <= 50)
    model.addConstr(3 * x0 + x1 <= 64)
    model.addConstr(6 * x0 + 6 * x1 <= 144)
    model.addConstr(6 * x0 + 7 * x2 <= 100)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("cornichons: ", x0.varValue)
        print("apples: ", x1.varValue)
        print("rotisserie_chickens: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
