
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B6")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B2")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="zinc")


# Set objective function
m.setObjective(1*x0**2 + 9*x0*x1 + 7*x0*x2 + 1*x1**2 + 9*x2**2 + 2*x0 + 4*x1 + 9*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9*x1 + 4*x2 >= 28, "c1")
m.addConstr(9*x0 + 4*x2 >= 15, "c2")
m.addConstr(9*x0 + 22*x1 + 4*x2 >= 15, "c3")
m.addConstr(9*x1 + 23*x2 >= 15, "c4")
m.addConstr(23*x0 + 23*x2 >= 30, "c5")
m.addConstr(23*x0**2 + 9*x1**2 + 23*x2**2 >= 21, "c6")
m.addConstr(23*x0 + 9*x1 + 23*x2 >= 21, "c7")
m.addConstr(16*x0 + 17*x2 >= 23, "c8")
m.addConstr(1*x1 + 17*x2 >= 28, "c9")
m.addConstr(16*x0 + 1*x1 + 17*x2 >= 28, "c10")
m.addConstr(3*x1 - 5*x2 >= 0, "c11")
m.addConstr(9*x0 + 22*x1 + 4*x2 <= 124, "c12")
m.addConstr(16*x0 + 1*x1 <= 71, "c13")
m.addConstr(16*x0 + 17*x2 <= 86, "c14")
m.addConstr(1*x1 + 17*x2 <= 97, "c15")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

