
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
x0 = model.addVar(vtype=gp.GRB.INTEGER, name="packs of paper")
x1 = model.addVar(vtype=gp.GRB.INTEGER, name="monochrome printers")
x2 = model.addVar(vtype=gp.GRB.INTEGER, name="wooden pencils")
x3 = model.addVar(vtype=gp.GRB.INTEGER, name="headsets")


# Set objective function
model.setObjective(4.14*x0**2 + 2.98*x0*x1 + 8.51*x0*x3 + 7.02*x1**2 + 9.85*x1*x3 + 3.74*x2**2 + 7.03*x3**2 + 5.49*x1 + 5.28*x3, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(3*x0 + 7*x1 <= 184)
model.addConstr(5*x0 + x1 + 7*x2 + 4*x3 <= 178)
model.addConstr(8*x0 + 3*x1 + 6*x2 + 6*x3 <= 123)
model.addConstr(5*x0 + 4*x1 + x2 + 6*x3 <= 55)
model.addConstr(3*x0 + 7*x1 >= 36)
model.addConstr(5*x0 + 4*x3 >= 30)
model.addConstr(x1 + 7*x2 >= 22)
model.addConstr(7*x2 + 4*x3 >= 28)
model.addConstr(5*x0**2 + x1**2 >= 18)
model.addConstr(x1 + 4*x3 >= 22)
model.addConstr(5*x0 + 7*x2 >= 37)
model.addConstr(x1**2 + 7*x2**2 + 4*x3**2 >= 41)
model.addConstr(5*x0 + x1 + 7*x2 >= 41)
model.addConstr(5*x0 + 7*x2 + 4*x3 >= 41)
model.addConstr(5*x0 + x1 + 4*x3 >= 41)
model.addConstr(x1**2 + 7*x2**2 + 4*x3**2 >= 34)
model.addConstr(5*x0 + x1 + 7*x2 >= 34)
model.addConstr(5*x0 + 7*x2 + 4*x3 >= 34)
model.addConstr(5*x0**2 + x1**2 + 4*x3**2 >= 34)
model.addConstr(x1**2 + 7*x2**2 + 4*x3**2 >= 43)
model.addConstr(5*x0 + x1 + 7*x2 >= 43)
model.addConstr(5*x0 + 7*x2 + 4*x3 >= 43)
model.addConstr(5*x0 + x1 + 4*x3 >= 43)
model.addConstr(x1**2 + 7*x2**2 + 4*x3**2 >= 32)
model.addConstr(5*x0 + x1 + 7*x2 >= 32)
model.addConstr(5*x0**2 + 7*x2**2 + 4*x3**2 >= 32)
model.addConstr(5*x0 + x1 + 4*x3 >= 32)
model.addConstr(x2 + 6*x3 >= 9)
model.addConstr(5*x0 + x2 >= 5)
model.addConstr(5*x0 + 4*x1 + 6*x3 >= 10)
model.addConstr(5*x0**2 + x2**2 + 6*x3**2 >= 10)
model.addConstr(5*x0**2 + 4*x1**2 + 6*x3**2 >= 11)
model.addConstr(5*x0 + x2 + 6*x3 >= 11)
model.addConstr(3*x0 + 7*x1 <= 165)
model.addConstr(7*x1 + x2 <= 78)
model.addConstr(7*x1 + x3 <= 64)
model.addConstr(3*x0 + x3 <= 57)
model.addConstr(3*x0 + 7*x1 + x2 + x3 <= 57)
model.addConstr(x1 + 7*x2 <= 162)
model.addConstr(x1 + 4*x3 <= 59)
model.addConstr(5*x0**2 + x1**2 + 4*x3**2 <= 172)
model.addConstr(5*x0 + x1 + 7*x2 + 4*x3 <= 172)
model.addConstr(6*x2**2 + 6*x3**2 <= 118)
model.addConstr(3*x1 + 6*x2 <= 46)
model.addConstr(3*x1**2 + 6*x3**2 <= 73)
model.addConstr(8*x0**2 + 3*x1**2 + 6*x3**2 <= 104)
model.addConstr(8*x0 + 3*x1 + 6*x2 + 6*x3 <= 104)
model.addConstr(4*x1**2 + x2**2 <= 44)
model.addConstr(5*x0 + 6*x3 <= 51)
model.addConstr(5*x0 + 4*x1 + 6*x3 <= 48)
model.addConstr(5*x0 + 4*x1 + x2 <= 26)
model.addConstr(5*x0 + x2 + 6*x3 <= 24)
model.addConstr(4*x1 + x2 + 6*x3 <= 29)
model.addConstr(5*x0 + 4*x1 + x2 + 6*x3 <= 29)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Packs of paper: {x0.x}")
    print(f"Monochrome printers: {x1.x}")
    print(f"Wooden pencils: {x2.x}")
    print(f"Headsets: {x3.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

