
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("minimize_labor_cost")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Mary")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hours_worked_by_Hank")


    # Set objective function
    m.setObjective(4.58 * x0 + 4.72 * x1, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14 * x0 + 3 * x1 >= 95, "c0")
    m.addConstr(13 * x0 + 9 * x1 >= 47, "c1")
    m.addConstr(5 * x0 - 4 * x1 >= 0, "c2")
    m.addConstr(14 * x0 + 3 * x1 <= 127, "c3")
    m.addConstr(13 * x0 + 9 * x1 <= 75, "c4")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization was infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

