
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="hours_worked_by_Mary")
x2 = m.addVar(lb=0, name="hours_worked_by_Hank")

# Set the objective function
m.setObjective(4.58*x1 + 4.72*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(14*x1 + 3*x2 >= 95, name="productivity_rating_constraint")
m.addConstr(13*x1 + 9*x2 >= 47, name="quit_index_lower_bound")
m.addConstr(5*x1 - 4*x2 >= 0, name="mixed_constraint")
m.addConstr(14*x1 + 3*x2 <= 127, name="productivity_rating_upper_bound")
m.addConstr(13*x1 + 9*x2 <= 75, name="quit_index_upper_bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Mary:", x1.x)
    print("Hours worked by Hank:", x2.x)
else:
    print("No optimal solution found. Status:", m.status)
