
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Mary", lb=0)  
    x2 = model.addVar(name="hours_worked_by_Hank", lb=0)   

    # Define the objective function
    model.setObjective(4.58 * x1 + 4.72 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(14 * x1 + 3 * x2 >= 95)
    model.addConstr(13 * x1 + 9 * x2 >= 47)
    model.addConstr(5 * x1 - 4 * x2 >= 0)
    model.addConstr(14 * x1 + 3 * x2 <= 127)
    model.addConstr(13 * x1 + 9 * x2 <= 75)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Mary: {x1.varValue}")
        print(f"Hours worked by Hank: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
