
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
hot_dogs = m.addVar(vtype=gp.GRB.INTEGER, name="hot_dogs")
green_beans = m.addVar(vtype=gp.GRB.CONTINUOUS, name="green_beans")
strawberries = m.addVar(vtype=gp.GRB.CONTINUOUS, name="strawberries")
eggs = m.addVar(vtype=gp.GRB.INTEGER, name="eggs")


# Set objective function
m.setObjective(2*hot_dogs*green_beans + 2*hot_dogs*strawberries + 2*green_beans*eggs + 5*green_beans + 6*strawberries, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17*hot_dogs + 10*green_beans + 16*strawberries + 24*eggs <= 305)
m.addConstr(22*hot_dogs + 17*green_beans + 3*strawberries + 9*eggs <= 538)
m.addConstr(24*hot_dogs + 18*green_beans + 13*strawberries + 5*eggs <= 246)
m.addConstr(21*hot_dogs + 9*green_beans + 1*strawberries + 16*eggs <= 460)
m.addConstr((16*strawberries)**2 + (24*eggs)**2 >= 25)
m.addConstr((17*hot_dogs)**2 + (24*eggs)**2 >= 63)
m.addConstr(17*hot_dogs + 10*green_beans >= 50)
m.addConstr(17*hot_dogs + 16*strawberries >= 32)
m.addConstr((10*green_beans)**2 + (16*strawberries)**2 >= 28)
m.addConstr((17*hot_dogs)**2 + (10*green_beans)**2 + (16*strawberries)**2 >= 74)
m.addConstr(17*green_beans + 9*eggs >= 129)
m.addConstr(9*green_beans + 1*strawberries >= 68)
m.addConstr(21*hot_dogs + 1*strawberries >= 98)
m.addConstr(21*hot_dogs + 9*green_beans + 16*eggs >= 70)
m.addConstr((17*hot_dogs)**2 + (10*green_beans)**2 <= 95)
m.addConstr((17*hot_dogs)**2 + (16*strawberries)**2 <= 179)
m.addConstr(16*strawberries + 24*eggs <= 167)
m.addConstr((10*green_beans)**2 + (16*strawberries)**2 <= 239)
m.addConstr((17*hot_dogs)**2 + (24*eggs)**2 <= 268)
m.addConstr(17*hot_dogs + 10*green_beans + 16*strawberries + 24*eggs <= 268)
m.addConstr((22*hot_dogs)**2 + (9*eggs)**2 <= 268)
m.addConstr((22*hot_dogs)**2 + (17*green_beans)**2 <= 139)
m.addConstr((3*strawberries)**2 + (9*eggs)**2 <= 270)
m.addConstr((17*green_beans)**2 + (9*eggs)**2 <= 269)
m.addConstr(17*green_beans + 3*strawberries <= 438)
m.addConstr(22*hot_dogs + 17*green_beans + 3*strawberries + 9*eggs <= 438)
m.addConstr(24*hot_dogs + 13*strawberries <= 138)
m.addConstr((24*hot_dogs)**2 + (5*eggs)**2 <= 183)
m.addConstr(13*strawberries + 5*eggs <= 204)
m.addConstr((18*green_beans)**2 + (13*strawberries)**2 <= 130)
m.addConstr(18*green_beans + 5*eggs <= 135)
m.addConstr((24*hot_dogs)**2 + (18*green_beans)**2 + (13*strawberries)**2 <= 187)
m.addConstr((24*hot_dogs)**2 + (13*strawberries)**2 + (5*eggs)**2 <= 215)
m.addConstr((18*green_beans)**2 + (13*strawberries)**2 + (5*eggs)**2 <= 116)
m.addConstr(24*hot_dogs + 18*green_beans + 13*strawberries + 5*eggs <= 116)
m.addConstr((9*green_beans)**2 + (16*eggs)**2 <= 457)
m.addConstr(21*hot_dogs + 9*green_beans <= 203)
m.addConstr(21*hot_dogs + 16*eggs <= 185)
m.addConstr(21*hot_dogs + 9*green_beans + 1*strawberries + 16*eggs <= 185)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

