
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
lightbulbs = m.addVar(vtype=gp.GRB.INTEGER, name="lightbulbs")
packs_of_napkins = m.addVar(vtype=gp.GRB.INTEGER, name="packs_of_napkins")
rubber_gloves = m.addVar(vtype=gp.GRB.INTEGER, name="rubber_gloves")
diapers = m.addVar(vtype=gp.GRB.INTEGER, name="diapers")
dish_soap_bottles = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap_bottles")


# Set objective function
m.setObjective(6.05 * lightbulbs + 1.69 * packs_of_napkins + 9.85 * rubber_gloves + 2.96 * diapers + 2.44 * dish_soap_bottles, gp.GRB.MINIMIZE)

# Add constraints
resource_constraints = {
    'r0': {'coef': [1, 26, 19, 10, 11], 'ub': 540},
    'r1': {'coef': [26, 20, 15, 6, 22], 'ub': 524},
    'r2': {'coef': [17, 2, 10, 8, 8], 'ub': 267},
    'r3': {'coef': [21, 9, 9, 15, 26], 'ub': 253}
}
vars = [lightbulbs, packs_of_napkins, rubber_gloves, diapers, dish_soap_bottles]

for r, data in resource_constraints.items():
    m.addConstr(gp.LinExpr(data['coef'], vars) <= data['ub'], name=r)


m.addConstr(lightbulbs + 19 * rubber_gloves >= 83)
m.addConstr(10 * diapers + 11 * dish_soap_bottles >= 67)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

