
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="lightbulbs", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="packs of napkins", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="rubber gloves", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="diapers", vtype=gurobi.GRB.INTEGER)
x4 = m.addVar(name="dish soap bottles", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(6.05 * x0 + 1.69 * x1 + 9.85 * x2 + 2.96 * x3 + 2.44 * x4, gurobi.GRB.MINIMIZE)

# Add constraints
# Sustainability score constraints
m.addConstr(x0 + 19 * x2 >= 83)
m.addConstr(10 * x3 + 11 * x4 >= 67)
m.addConstr(x0 + 26 * x1 + 19 * x2 >= 101)
m.addConstr(x0 + 26 * x1 + 11 * x4 >= 101)
m.addConstr(x0 + 26 * x1 + 19 * x2 >= 76)
m.addConstr(x0 + 26 * x1 + 11 * x4 >= 76)
m.addConstr(x0 + 26 * x1 + 19 * x2 + 10 * x3 + 11 * x4 >= 76)

# Value constraints
m.addConstr(6 * x3 + 22 * x4 >= 65)
m.addConstr(20 * x1 + 6 * x3 >= 76)
m.addConstr(26 * x0 + 22 * x4 >= 76)
m.addConstr(20 * x1 + 22 * x4 >= 85)
m.addConstr(20 * x1 + 15 * x2 >= 49)
m.addConstr(26 * x0 + 20 * x1 >= 42)
m.addConstr(26 * x0 + 6 * x3 + 22 * x4 >= 65)
m.addConstr(15 * x2 + 6 * x3 + 22 * x4 >= 65)
m.addConstr(20 * x1 + 15 * x2 + 22 * x4 >= 65)
m.addConstr(26 * x0 + 15 * x2 + 22 * x4 >= 65)

# Storage space constraints
m.addConstr(17 * x0 + 10 * x2 + 8 * x3 >= 39)
m.addConstr(17 * x0 + 8 * x4 >= 26)
m.addConstr(2 * x1 + 10 * x2 + 8 * x3 >= 39)

# Weight constraints
m.addConstr(9 * x1 + 26 * x4 >= 41)
m.addConstr(15 * x3 + 26 * x4 >= 34)

# Other constraints
m.addConstr(-8 * x1 + 7 * x2 >= 0)
m.addConstr(-3 * x1 + 2 * x3 >= 0)
m.addConstr(x0 + 19 * x2 <= 532)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Lightbulbs: ", x0.varValue)
    print("Packs of napkins: ", x1.varValue)
    print("Rubber gloves: ", x2.varValue)
    print("Diapers: ", x3.varValue)
    print("Dish soap bottles: ", x4.varValue)
else:
    print("No solution found")
