
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, name="x0")  # milligrams of vitamin C
x1 = m.addVar(lb=0, name="x1")  # grams of protein
x2 = m.addVar(lb=0, name="x2")  # milligrams of vitamin B7
x3 = m.addVar(lb=0, name="x3")  # milligrams of vitamin B1


# Set objective function
m.setObjective(2.67*x0**2 + 7.7*x0*x1 + 5.67*x0*x3 + 3.59*x1**2 + 8.32*x1*x2 + 8.4*x1*x3 + 1.38*x2**2 + 6.33*x2*x3 + 1.3*x0 + 5.9*x1 + 6.26*x2 + 3.36*x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x0 + 10*x1 + 6*x2 + 16*x3 <= 246, "c0")
m.addConstr(10*x0**2 + 16*x3**2 >= 22, "c1")
m.addConstr(10*x0 + 6*x2 >= 50, "c2")
m.addConstr(10*x1 + 6*x2 >= 44, "c3")
m.addConstr(10*x0 + 10*x1 + 16*x3 >= 42, "c4")
m.addConstr(10*x0 + 6*x2 + 16*x3 >= 42, "c5")
m.addConstr(10*x1 + 6*x2 + 16*x3 >= 42, "c6")
m.addConstr(10*x0 + 10*x1 + 16*x3 >= 30, "c7")
m.addConstr(10*x0 + 6*x2 + 16*x3 >= 30, "c8")
m.addConstr(10*x1 + 6*x2 + 16*x3 >= 30, "c9")
m.addConstr(10*x0 + 10*x1 + 16*x3 >= 38, "c10")
m.addConstr(10*x0**2 + 6*x2**2 + 16*x3**2 >= 38, "c11")
m.addConstr(10*x1 + 6*x2 + 16*x3 >= 38, "c12")
m.addConstr(10*x0 + 10*x1 + 6*x2 + 16*x3 >= 38, "c13")
m.addConstr(-2*x2 + 3*x3 >= 0, "c14")
m.addConstr(10*x1 + 6*x2 <= 104, "c15")
m.addConstr(10*x0**2 + 10*x1**2 + 6*x2**2 <= 118, "c16")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

