
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='milligrams of vitamin C')
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='grams of protein')
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='milligrams of vitamin B7')
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='milligrams of vitamin B1')

    # Define the objective function
    model.setObjective(2.67*x1**2 + 7.7*x1*x2 + 5.67*x1*x4 + 3.59*x2**2 + 8.32*x2*x3 + 8.4*x2*x4 + 1.38*x3**2 + 6.33*x3*x4 + 1.3*x1 + 5.9*x2 + 6.26*x3 + 3.36*x4)

    # Add constraints
    model.addConstr(10*x1 + 10*x2 + 6*x3 + 16*x4 <= 246)
    model.addConstr(10*x1**2 + 16*x4**2 >= 22)
    model.addConstr(10*x1 + 6*x3 >= 50)
    model.addConstr(10*x2 + 6*x3 >= 44)
    model.addConstr(10*x1 + 10*x2 + 16*x4 >= 42)
    model.addConstr(10*x1 + 6*x3 + 16*x4 >= 42)
    model.addConstr(10*x2 + 6*x3 + 16*x4 >= 42)
    model.addConstr(10*x1 + 10*x2 + 16*x4 >= 30)
    model.addConstr(10*x1 + 6*x3 + 16*x4 >= 30)
    model.addConstr(10*x2 + 6*x3 + 16*x4 >= 30)
    model.addConstr(10*x1 + 10*x2 + 16*x4 >= 38)
    model.addConstr(10*x1**2 + 6*x3**2 + 16*x4**2 >= 38)
    model.addConstr(10*x2 + 6*x3 + 16*x4 >= 38)
    model.addConstr(10*x1 + 10*x2 + 6*x3 + 16*x4 >= 38)
    model.addConstr(-2*x3 + 3*x4 >= 0)
    model.addConstr(10*x2 + 6*x3 <= 104)
    model.addConstr(10*x1**2 + 10*x2**2 + 6*x3**2 <= 118)

    # Set the objective to minimize
    model.setAttr(gurobi.GRB.Attr.Sense, gurobi.GRB.MINIMIZE)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
    else:
        print('The model is infeasible')

solve_optimization_problem()
