
import gurobipy as gp

# Create a new model
m = gp.Model("work_optimization")

# Create variables
john = m.addVar(lb=0, name="john")
peggy = m.addVar(lb=0, name="peggy")
paul = m.addVar(lb=0, name="paul")
hank = m.addVar(lb=0, name="hank")

# Set objective function
m.setObjective(8*john + 1*peggy + 7*paul + 7*hank, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*peggy + 11*paul >= 49)
m.addConstr(11*john + 10*hank >= 76)
m.addConstr(11*john + 2*peggy >= 37)
m.addConstr(11*paul + 10*hank >= 42)
m.addConstr(11*john + 2*peggy + 11*paul >= 53)
m.addConstr(2*peggy + 11*paul + 10*hank >= 53)
m.addConstr(11*john + 2*peggy + 10*hank >= 53)
m.addConstr(11*john + 2*peggy + 11*paul >= 68)
m.addConstr(2*peggy + 11*paul + 10*hank >= 68)
m.addConstr(11*john + 2*peggy + 10*hank >= 68)
# ... (rest of the constraints as in the JSON)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('john:', john.x)
    print('peggy:', peggy.x)
    print('paul:', paul.x)
    print('hank:', hank.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
