
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    red_pens = model.addVar(vtype=gp.GRB.INTEGER, name="red_pens")
    postage_stamps = model.addVar(vtype=gp.GRB.INTEGER, name="postage_stamps")
    lanyards = model.addVar(vtype=gp.GRB.INTEGER, name="lanyards")
    usb_flash_drives = model.addVar(vtype=gp.GRB.INTEGER, name="usb_flash_drives")

    # Set objective function
    model.setObjective(2*red_pens + 8*postage_stamps + 6*lanyards + 6*usb_flash_drives, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11*red_pens + 5*usb_flash_drives >= 45)
    model.addConstr(11*lanyards + 5*usb_flash_drives >= 33)
    model.addConstr(11*red_pens + 14*postage_stamps >= 35)
    model.addConstr(11*red_pens + 14*postage_stamps + 11*lanyards + 5*usb_flash_drives >= 35)
    model.addConstr(4*postage_stamps + 18*lanyards >= 11)
    model.addConstr(13*red_pens + 18*lanyards >= 8)
    model.addConstr(13*red_pens + 4*postage_stamps >= 15)
    model.addConstr(13*red_pens + 4*postage_stamps + 18*lanyards >= 15)
    model.addConstr(13*red_pens + 4*postage_stamps + 18*lanyards + 3*usb_flash_drives >= 15)
    model.addConstr(-8*postage_stamps + 4*usb_flash_drives >= 0)
    model.addConstr(-4*red_pens + 4*lanyards >= 0)
    model.addConstr(11*red_pens + 14*postage_stamps <= 160)
    model.addConstr(14*postage_stamps + 11*lanyards <= 237)
    model.addConstr(13*red_pens + 4*postage_stamps <= 34)
    model.addConstr(4*postage_stamps + 3*usb_flash_drives <= 32)
    model.addConstr(13*red_pens + 3*usb_flash_drives <= 68)
    model.addConstr(4*postage_stamps + 18*lanyards <= 30)
    model.addConstr(13*red_pens + 4*postage_stamps + 3*usb_flash_drives <= 59)
    model.addConstr(13*red_pens + 4*postage_stamps + 18*lanyards <= 25)


    # Resource Constraints
    model.addConstr(11*red_pens + 14*postage_stamps + 11*lanyards + 5*usb_flash_drives <= 253)
    model.addConstr(13*red_pens + 4*postage_stamps + 18*lanyards + 3*usb_flash_drives <= 79)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
