
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="red_pens", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="postage_stamps", vtype=gurobi.GRB.INTEGER)
x2 = model.addVar(name="lanyards", vtype=gurobi.GRB.INTEGER)
x3 = model.addVar(name="usb_flash_drives", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(2*x0 + 8*x1 + 6*x2 + 6*x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(11*x0 + 14*x1 + 11*x2 + 5*x3 <= 253)
model.addConstr(13*x0 + 4*x1 + 18*x2 + 3*x3 <= 79)
model.addConstr(11*x0 + 5*x3 >= 45)
model.addConstr(11*x2 + 5*x3 >= 33)
model.addConstr(11*x0 + 14*x1 >= 35)
model.addConstr(11*x0 + 14*x1 + 11*x2 + 5*x3 >= 35)
model.addConstr(4*x1 + 18*x2 >= 11)
model.addConstr(13*x0 + 18*x2 >= 8)
model.addConstr(13*x0 + 4*x1 >= 15)
model.addConstr(13*x0 + 4*x1 + 18*x2 >= 15)
model.addConstr(13*x0 + 4*x1 + 18*x2 + 3*x3 >= 15)
model.addConstr(-8*x1 + 4*x3 >= 0)
model.addConstr(-4*x0 + 4*x2 >= 0)
model.addConstr(11*x0 + 14*x1 <= 160)
model.addConstr(14*x1 + 11*x2 <= 237)
model.addConstr(13*x0 + 4*x1 <= 34)
model.addConstr(4*x1 + 3*x3 <= 32)
model.addConstr(13*x0 + 3*x3 <= 68)
model.addConstr(4*x1 + 18*x2 <= 30)
model.addConstr(13*x0 + 4*x1 + 3*x3 <= 59)
model.addConstr(13*x0 + 4*x1 + 18*x2 <= 25)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Red pens: ", x0.varValue)
    print("Postage stamps: ", x1.varValue)
    print("Lanyards: ", x2.varValue)
    print("USB flash drives: ", x3.varValue)
else:
    print("The model is infeasible")
