
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
    x1 = m.addVar(vtype=GRB.INTEGER, name="artillery_batteries")


    # Set objective function
    m.setObjective(7*x0**2 + 6*x0*x1 + 6*x1**2 + 3*x1, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(12*x0**2 + 18*x1**2 >= 55, "c1")
    m.addConstr(12*x0**2 + 1*x1**2 >= 21, "c2")
    m.addConstr(-5*x0**2 + 9*x1**2 >= 0, "c3")
    m.addConstr(12*x0**2 + 18*x1**2 <= 90, "c4")
    m.addConstr(12*x0 + 18*x1 <= 90, "c5")
    m.addConstr(12*x0 + 1*x1 <= 76, "c6")



    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

