
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="air_defense_batteries")
x2 = m.addVar(vtype=GRB.INTEGER, name="artillery_batteries")

# Set objective function
m.setObjective(7*x1**2 + 6*x1*x2 + 6*x2**2 + 3*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr((12*x1 + 18*x2)**2 >= 55, name="defensive_capability_min")
m.addConstr((12*x1 + x2)**2 >= 21, name="deployment_weight_min_squared")
m.addConstr(-5*x1**2 + 9*x2**2 >= 0, name="mixed_constraint")
m.addConstr((12*x1 + 18*x2)**2 <= 90, name="defensive_capability_max_squared")
m.addConstr(12*x1 + 18*x2 <= 90, name="defensive_capability_max")
m.addConstr(12*x1 + x2 <= 76, name="deployment_weight_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Air Defense Batteries:", x1.x)
    print("Artillery Batteries:", x2.x)
    print("Objective Function Value:", m.objVal)
else:
    print("No optimal solution found")
