
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="air_defense_batteries", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="artillery_batteries", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7*x1**2 + 6*x1*x2 + 6*x2**2 + 3*x2, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(12*x1 <= 154, name="def_cap_rating_air_defense")
m.addConstr(12*x1 <= 93, name="deployment_weight_air_defense")
m.addConstr(18*x2 <= 154, name="def_cap_rating_artillery")
m.addConstr(x2 <= 93, name="deployment_weight_artillery")
m.addConstr(x1**2 + x2**2 >= 55, name="total_def_cap_rating")
m.addConstr(12*x1 + x2 >= 21, name="deployment_weight_total")
m.addConstr(-5*x1**2 + 9*x2**2 >= 0, name="def_cap_rating_relation")
m.addConstr(x1**2 + x2**2 <= 90, name="total_def_cap_rating_limit")
m.addConstr(12*x1 + 18*x2 <= 90, name="total_def_cap_rating_joint_limit")
m.addConstr(12*x1 + x2 <= 76, name="total_deployment_weight_limit")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Air defense batteries: ", x1.varValue)
    print("Artillery batteries: ", x2.varValue)
else:
    print("The model is infeasible")
