
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="air_defense_batteries")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="mechanized_infantry_companies")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="signal_platoons")
x3 = m.addVar(vtype=gp.GRB.INTEGER, name="reconnaissance_troops")


# Set objective function
m.setObjective(4*x0**2 + 6*x0*x2 + 7*x0*x3 + 5*x1**2 + 7*x1*x2 + 3*x1 + 9*x2 + x3, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4*x0 + x1 + 3*x2 + 3*x3 <= 135, "c0")
m.addConstr(3*x0 + 2*x1 + 5*x2 + x3 <= 124, "c1")
m.addConstr(2*x0 + 5*x1 + x2 + 3*x3 <= 115, "c2")
m.addConstr(x1**2 + x3**2 >= 12, "c3")
m.addConstr(4*x0 + 3*x2 >= 22, "c4")
m.addConstr(4*x0 + x1 + 3*x2 >= 31, "c5")
m.addConstr(4*x0 + 3*x2 + 3*x3 >= 31, "c6")
m.addConstr(x1**2 + x2**2 + x3**2 >= 31, "c7")
m.addConstr(4*x0 + x1 + 3*x2 >= 18, "c8")
m.addConstr(4*x0 + 3*x2 + 3*x3 >= 18, "c9")
m.addConstr(x1 + 3*x2 + 3*x3 >= 18, "c10")
m.addConstr(4*x0**2 + x1**2 + 3*x2**2 >= 27, "c11")
m.addConstr(4*x0 + 3*x2 + 3*x3 >= 27, "c12")
m.addConstr(x1 + 3*x2 + 3*x3 >= 27, "c13")
m.addConstr(4*x0 + x1 + 3*x2 + 3*x3 >= 27, "c14")
m.addConstr(3*x0 + 5*x2 >= 12, "c15")
m.addConstr(2*x1 + x3 >= 26, "c16")
m.addConstr(3*x0 + 2*x1 + 5*x2 >= 20, "c17")
m.addConstr(2*x1**2 + 5*x2**2 + x3**2 >= 20, "c18")
m.addConstr(3*x0**2 + 5*x2**2 + x3**2 >= 20, "c19")
m.addConstr(3*x0 + 2*x1 + 5*x2 >= 19, "c20")
m.addConstr(2*x1**2 + 5*x2**2 + x3**2 >= 19, "c21")
m.addConstr(3*x0 + 5*x2 + x3 >= 19, "c22")
m.addConstr(3*x0**2 + 2*x1**2 + 5*x2**2 >= 29, "c23")
m.addConstr(2*x1 + 5*x2 + x3 >= 29, "c24")
m.addConstr(3*x0 + 5*x2 + x3 >= 29, "c25")
m.addConstr(3*x0 + 2*x1 + 5*x2 + x3 >= 29, "c26")
m.addConstr(5*x1**2 + 3*x3**2 >= 28, "c27")
m.addConstr(5*x1**2 + x2**2 >= 24, "c28")
m.addConstr(2*x0 + x2 >= 26, "c29")
m.addConstr(2*x0**2 + 5*x1**2 >= 25, "c30")
m.addConstr(x2 + 3*x3 >= 21, "c31")
m.addConstr(2*x0 + 5*x1 + x2 + 3*x3 >= 21, "c32")
m.addConstr(3*x2**2 - 4*x3**2 >= 0, "c33")
m.addConstr(-3*x0 + 3*x2 >= 0, "c34")
m.addConstr(4*x0 + x1 + 3*x2 <= 113, "c35")
m.addConstr(3*x0**2 + 2*x1**2 <= 35, "c36")
m.addConstr(5*x2 + x3 <= 59, "c37")
m.addConstr(3*x0 + x3 <= 69, "c38")
m.addConstr(2*x0 + x2 + 3*x3 <= 65, "c39")


# Optimize model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('The problem is unbounded or something else happened.')

