
import gurobi

def optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", vtype=gurobi.GRB.INTEGER)  # air defense batteries
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # mechanized infantry companies
    x2 = model.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # signal platoons
    x3 = model.addVar(name="x3", vtype=gurobi.GRB.INTEGER)  # reconnaissance troops

    # Objective function
    model.setObjective(4 * x0**2 + 6 * x0 * x2 + 7 * x0 * x3 + 5 * x1**2 + 7 * x1 * x2 + 3 * x1 + 9 * x2**2 + x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4 * x0 + x1 + 3 * x2 + 3 * x3 <= 135)
    model.addConstr(3 * x0 + 2 * x1 + 5 * x2 + x3 >= 124)
    model.addConstr(2 * x0 + 5 * x1 + x2 + 3 * x3 <= 115)
    model.addConstr(x1**2 + x3**2 >= 12)
    model.addConstr(4 * x0 + 3 * x2 >= 22)
    model.addConstr(4 * x0 + x1 + 3 * x2 >= 31)
    model.addConstr(4 * x0 + 3 * x2 + 3 * x3 >= 31)
    model.addConstr(x1**2 + x2**2 + x3**2 >= 31)
    model.addConstr(4 * x0 + x1 + 3 * x2 >= 18)
    model.addConstr(4 * x0 + 3 * x2 + 3 * x3 >= 18)
    model.addConstr(x1 + 3 * x2 + 3 * x3 >= 18)
    model.addConstr(16 * x0**2 + x1**2 + 9 * x2**2 >= 27)
    model.addConstr(4 * x0 + 3 * x2 + 3 * x3 >= 27)
    model.addConstr(x1 + 3 * x2 + 3 * x3 >= 27)
    model.addConstr(4 * x0 + x1 + 3 * x2 + 3 * x3 >= 27)
    model.addConstr(3 * x0 + 5 * x2 >= 12)
    model.addConstr(2 * x1 + x3 >= 26)
    model.addConstr(3 * x0 + 2 * x1 + 5 * x2 >= 20)
    model.addConstr(x1**2 + x2**2 + x3**2 >= 20)
    model.addConstr(9 * x0**2 + x2**2 + x3**2 >= 20)
    model.addConstr(3 * x0 + 2 * x1 + 5 * x2 >= 19)
    model.addConstr(x1**2 + x2**2 + x3**2 >= 19)
    model.addConstr(3 * x0 + 5 * x2 + x3 >= 19)
    model.addConstr(9 * x0**2 + x1**2 + 9 * x2**2 >= 29)
    model.addConstr(x1 + 5 * x2 + x3 >= 29)
    model.addConstr(3 * x0 + 5 * x2 + x3 >= 29)
    model.addConstr(3 * x0 + 2 * x1 + 5 * x2 + x3 >= 29)
    model.addConstr(2 * x1**2 + 3 * x3**2 >= 28)
    model.addConstr(x1**2 + 9 * x2**2 >= 24)
    model.addConstr(2 * x0 + x2 >= 26)
    model.addConstr(4 * x0**2 + x1**2 >= 25)
    model.addConstr(x2 + 3 * x3 >= 21)
    model.addConstr(2 * x0 + 5 * x1 + x2 + 3 * x3 >= 21)
    model.addConstr(3 * x2**2 - 4 * x3**2 >= 0)
    model.addConstr(-3 * x0 + 3 * x2 >= 0)
    model.addConstr(4 * x0 + x1 + 3 * x2 <= 113)
    model.addConstr(9 * x0**2 + x1**2 <= 35)
    model.addConstr(5 * x2 + x3 <= 59)
    model.addConstr(3 * x0 + x3 <= 69)
    model.addConstr(2 * x0 + x2 + 3 * x3 <= 65)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {model.x[0].x}, x1: {model.x[1].x}, x2: {model.x[2].x}, x3: {model.x[3].x}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
