
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(vtype=GRB.INTEGER, name="peanutbutter sandwiches")
x1 = m.addVar(vtype=GRB.INTEGER, name="bagged salads")
x2 = m.addVar(vtype=GRB.INTEGER, name="granola bars")
x3 = m.addVar(vtype=GRB.INTEGER, name="blueberry pies")
x4 = m.addVar(vtype=GRB.INTEGER, name="oranges")
x5 = m.addVar(vtype=GRB.INTEGER, name="apple pies")


# Set objective function
m.setObjective(4*x0**2 + 4*x0*x4 + 8*x1**2 + 7*x1*x5 + 4*x2**2 + 4*x2*x4 + 3*x2*x5 + 4*x3*x4 + 6*x4**2 + 2*x5**2 + 9*x2 + 2*x3 + 9*x4, GRB.MINIMIZE)

# Add constraints
m.addConstr(5*x0 + 15*x1 + 3*x2 + 8*x3 + 15*x4 + 13*x5 <= 520, "r0")
m.addConstr(5*x0 + 8*x1 + 3*x2 + 8*x3 + 13*x4 + 16*x5 <= 212, "r1")
m.addConstr(14*x0 + 16*x1 + 7*x2 + 9*x3 + 1*x4 + 1*x5 <= 554, "r2")
m.addConstr(8*x3 + 15*x4 >= 76, "c3")
m.addConstr(3*x2 + 15*x4 >= 31, "c4")
m.addConstr(15*x4 + 13*x5 >= 49, "c5")
m.addConstr(3*x2**2 + 8*x3**2 >= 50, "c6")
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

