
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="squash_plants")
    x1 = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")


    # Set objective function
    m.setObjective(2.74*x0**2 + 5.48*x0*x1 + 8.46*x1**2 + 5.27*x0 + 2.9*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(33*x0 + 25*x1 >= 101, "c1")
    m.addConstr(33*x0 + 25*x1 <= 206, "c2")
    m.addConstr(11*x0 + 15*x1 >= 143, "c3")
    m.addConstr((11*x0)**2 + (15*x1)**2 <= 159, "c4") # Note: units are inconsistent here. Assuming 159 is also in inches squared.
    m.addConstr(11*x0 + 30*x1 >= 75, "c5")
    m.addConstr((11*x0)**2 + (30*x1)**2 <= 162, "c6") # Note: units are inconsistent here. Assuming 162 is also in inches squared.
    m.addConstr(3*x0 - x1 >= 0, "c7")
    m.addConstr(33*x0 <= 251, "c8")
    m.addConstr(11*x0 + 15*x1 <= 311, "c9")
    m.addConstr(11*x0 + 30*x1 <= 169, "c10")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        print('squash_plants:', x0.x)
        print('cherry_trees:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
