
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="squash_plants")
x2 = m.addVar(vtype=GRB.INTEGER, name="cherry_trees")

# Objective function
m.setObjective(2.74*x1**2 + 5.48*x1*x2 + 8.46*x2**2 + 5.27*x1 + 2.9*x2, GRB.MINIMIZE)

# Constraints
m.addConstr(33*x1 + 25*x2 >= 101, name="min_beauty_rating")
m.addConstr(33*x1 + 25*x2 <= 206, name="max_beauty_rating")
m.addConstr((33*x1)**2 + (25*x2)**2 >= 101, name="squared_min_beauty_rating")
m.addConstr(11*x1 + 15*x2 >= 143, name="min_planting_space")
m.addConstr((11*x1)**2 + (15*x2)**2 <= 159, name="max_squared_planting_space")
m.addConstr(11*x1 + 30*x2 >= 75, name="min_water_need")
m.addConstr(3*x1 - x2 >= 0, name="relationship_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Squash plants: {x1.x}")
    print(f"Cherry trees: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
