
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="squash_plants", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cherry_trees", vtype=gurobi.GRB.INTEGER)
    
    # Objective function
    model.setObjective(2.74*x1**2 + 5.48*x1*x2 + 8.46*x2**2 + 5.27*x1 + 2.9*x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(33*x1 + 25*x2 >= 101)
    model.addConstr(x1**2 + x2**2 >= 101)
    model.addConstr(11*x1 + 15*x2 >= 143)
    model.addConstr(11*x1 + 30*x2 >= 75)
    model.addConstr(3*x1 - x2 >= 0)
    model.addConstr(33*x1 + 25*x2 <= 206)
    model.addConstr(121*x1**2 + 225*x2**2 <= 159)
    model.addConstr(121*x1**2 + 900*x2**2 <= 162)
    
    # Solve the problem
    model.optimize()
    
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Squash plants: {x1.varValue}, Cherry trees: {x2.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The problem is infeasible.")
    else:
        print("The model status is: ", model.status)

optimize_problem()
