
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
fruit_salads = model.addVar(vtype=gp.GRB.INTEGER, name="fruit_salads")
apples = model.addVar(vtype=gp.GRB.INTEGER, name="apples")
steaks = model.addVar(vtype=gp.GRB.INTEGER, name="steaks")

# Set objective function
model.setObjective(6 * fruit_salads + 6 * apples + 9 * steaks, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(13 * apples + 8 * steaks >= 29, "c1")
model.addConstr(7 * fruit_salads + 8 * steaks >= 15, "c2")
model.addConstr(7 * fruit_salads + 13 * apples + 8 * steaks >= 41, "c3")
model.addConstr(6 * apples + 3 * steaks >= 14, "c4")
model.addConstr(10 * fruit_salads + 3 * steaks >= 10, "c5")
model.addConstr(10 * fruit_salads + 6 * apples + 3 * steaks >= 10, "c6")
model.addConstr(9 * apples + 5 * steaks >= 18, "c7")
model.addConstr(8 * fruit_salads + 9 * apples + 5 * steaks >= 21, "c8")
model.addConstr(2 * fruit_salads + 13 * apples >= 9, "c9")
model.addConstr(2 * fruit_salads + 13 * apples + 14 * steaks >= 9, "c10")
model.addConstr(-7 * fruit_salads + 2 * steaks >= 0, "c11")
model.addConstr(5 * fruit_salads - 2 * apples >= 0, "c12")
model.addConstr(10 * fruit_salads + 6 * apples <= 35, "c13")
model.addConstr(10 * fruit_salads + 6 * apples + 3 * steaks <= 34, "c14")
model.addConstr(8 * fruit_salads + 9 * apples <= 39, "c15")
model.addConstr(9 * apples + 5 * steaks <= 69, "c16")
model.addConstr(8 * fruit_salads + 5 * steaks <= 61, "c17")
model.addConstr(8 * fruit_salads + 9 * apples + 5 * steaks <= 99, "c18")
model.addConstr(2 * fruit_salads + 14 * steaks <= 69, "c19")


# Resource Constraints
model.addConstr(7 * fruit_salads + 13 * apples + 8 * steaks <= 130, "r0")
model.addConstr(10 * fruit_salads + 6 * apples + 3 * steaks <= 46, "r1")
model.addConstr(8 * fruit_salads + 9 * apples + 5 * steaks <= 99, "r2")
model.addConstr(2 * fruit_salads + 13 * apples + 14 * steaks <= 69, "r3")



# Optimize model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    for v in model.getVars():
        print('%s %g' % (v.varName, v.x))
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("The model could not be solved to optimality.")

