
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="fruit_salads", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="apples", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="steaks", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(6*x0 + 6*x1 + 9*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(7*x0 + 13*x1 + 8*x2 <= 130)
    model.addConstr(10*x0 + 6*x1 + 3*x2 <= 46)
    model.addConstr(8*x0 + 9*x1 + 5*x2 <= 99)
    model.addConstr(2*x0 + 13*x1 + 14*x2 <= 69)
    model.addConstr(13*x1 + 8*x2 >= 29)
    model.addConstr(7*x0 + 8*x2 >= 15)
    model.addConstr(7*x0 + 13*x1 + 8*x2 >= 41)
    model.addConstr(10*x0 + 6*x1 + 3*x2 >= 10)
    model.addConstr(6*x1 + 3*x2 >= 14)
    model.addConstr(8*x0 + 9*x1 + 5*x2 >= 21)
    model.addConstr(9*x1 + 5*x2 >= 18)
    model.addConstr(2*x0 + 13*x1 >= 9)
    model.addConstr(2*x0 + 13*x1 + 14*x2 >= 9)
    model.addConstr(-7*x0 + 2*x2 >= 0)
    model.addConstr(5*x0 - 2*x1 >= 0)
    model.addConstr(10*x0 + 6*x1 <= 35)
    model.addConstr(10*x0 + 6*x1 + 3*x2 <= 34)
    model.addConstr(8*x0 + 9*x1 <= 39)
    model.addConstr(9*x1 + 5*x2 <= 69)
    model.addConstr(8*x0 + 5*x2 <= 61)
    model.addConstr(2*x0 + 14*x2 <= 69)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Fruit Salads: ", x0.varValue)
        print("Apples: ", x1.varValue)
        print("Steaks: ", x2.varValue)
    else:
        print("No solution found")

solve_optimization_problem()
