
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("Computer_Competence_Optimization")

    # Create variables
    laura_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")
    bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")


    # Set objective function
    model.setObjective(9 * laura_hours + 4 * bobby_hours, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(0.46 * laura_hours + 6.11 * bobby_hours >= 37, "computer_competence_min")
    model.addConstr(-1 * laura_hours + 4 * bobby_hours >= 0, "hours_relation")
    model.addConstr(0.46 * laura_hours + 6.11 * bobby_hours <= 102, "computer_competence_max")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal Solution:")
        print(f"Hours worked by Laura: {laura_hours.x}")
        print(f"Hours worked by Bobby: {bobby_hours.x}")
        print(f"Objective Value: {model.objVal}")

except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
