
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="hours_worked_by_Laura")
x2 = m.addVar(lb=0, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(9*x1 + 4*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.46*x1 + 6.11*x2 >= 37, "computer_competence_rating_min")
m.addConstr(-x1 + 4*x2 >= 0, "hours_worked_constraint")
m.addConstr(0.46*x1 + 6.11*x2 <= 102, "computer_competence_rating_max")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {x1.x}")
    print(f"Hours worked by Bobby: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
