
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='hours_worked_by_Laura', lb=0)  # Laura
x2 = model.addVar(name='hours_worked_by_Bobby', lb=0)  # Bobby

# Define the objective function
model.setObjective(9 * x1 + 4 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(0.46 * x1 + 6.11 * x2 >= 37, name='min_computer_competence')
model.addConstr(-x1 + 4 * x2 >= 0, name='bobby_laura_ratio')
model.addConstr(0.46 * x1 + 6.11 * x2 <= 102, name='max_computer_competence')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Optimal solution found.')
    print(f'Hours worked by Laura: {x1.varValue}')
    print(f'Hours worked by Bobby: {x2.varValue}')
    print(f'Objective function value: {model.objVal}')
else:
    print('No optimal solution found.')
