
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    kiwis = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kiwis")
    bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
    corn_cobs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="corn_cobs")


    # Set objective function
    m.setObjective(8*kiwis + 4*bananas + 6*corn_cobs, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(4*kiwis + 4*corn_cobs >= 40, "c1")
    m.addConstr(24*bananas + 4*corn_cobs >= 88, "c2")
    m.addConstr(4*kiwis + 24*bananas + 4*corn_cobs >= 88, "c3")
    m.addConstr(17*kiwis + 7*corn_cobs >= 88, "c4")
    m.addConstr(17*kiwis + 35*bananas >= 111, "c5")
    m.addConstr(17*kiwis + 35*bananas + 7*corn_cobs >= 111, "c6")
    m.addConstr(20*bananas + 34*corn_cobs >= 130, "c7")
    m.addConstr(22*kiwis + 20*bananas >= 127, "c8")
    m.addConstr(22*kiwis + 20*bananas + 34*corn_cobs >= 127, "c9")
    m.addConstr(6*kiwis - 3*corn_cobs >= 0, "c10")
    m.addConstr(22*kiwis + 20*bananas + 34*corn_cobs <= 360, "c11")

    # Resource Constraints
    m.addConstr(4*kiwis <= 266, "carbohydrates_kiwis")
    m.addConstr(17*kiwis <= 381, "cost_kiwis")
    m.addConstr(22*kiwis <= 448, "iron_kiwis")

    m.addConstr(24*bananas <= 266, "carbohydrates_bananas")
    m.addConstr(35*bananas <= 381, "cost_bananas")
    m.addConstr(20*bananas <= 448, "iron_bananas")

    m.addConstr(4*corn_cobs <= 266, "carbohydrates_corn_cobs")
    m.addConstr(7*corn_cobs <= 381, "cost_corn_cobs")
    m.addConstr(34*corn_cobs <= 448, "iron_corn_cobs")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
