
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="kiwis", lb=0)  # kiwis
x1 = m.addVar(name="bananas", lb=0)  # bananas
x2 = m.addVar(name="corn_cobs", lb=0)  # corn cobs

# Define the objective function
m.setObjective(8 * x0 + 4 * x1 + 6 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * x0 <= 266)
m.addConstr(17 * x0 <= 381)
m.addConstr(22 * x0 <= 448)
m.addConstr(24 * x1 <= 266)
m.addConstr(35 * x1 <= 381)
m.addConstr(20 * x1 <= 448)
m.addConstr(4 * x2 <= 266)
m.addConstr(7 * x2 <= 381)
m.addConstr(34 * x2 <= 448)
m.addConstr(4 * x0 + 4 * x2 >= 40)
m.addConstr(24 * x1 + 4 * x2 >= 88)
m.addConstr(4 * x0 + 24 * x1 + 4 * x2 >= 88)
m.addConstr(17 * x0 + 7 * x2 >= 88)
m.addConstr(17 * x0 + 35 * x1 >= 111)
m.addConstr(17 * x0 + 35 * x1 + 7 * x2 >= 111)
m.addConstr(20 * x1 + 34 * x2 >= 130)
m.addConstr(22 * x0 + 20 * x1 >= 127)
m.addConstr(22 * x0 + 20 * x1 + 34 * x2 >= 127)
m.addConstr(6 * x0 - 3 * x2 >= 0)
m.addConstr(22 * x0 + 20 * x1 + 34 * x2 <= 360)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Kiwis: ", x0.varValue)
    print("Bananas: ", x1.varValue)
    print("Corn Cobs: ", x2.varValue)
else:
    print("The model is infeasible")
