
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0)  # hours worked by Hank
x1 = m.addVar(name="x1", lb=0)  # hours worked by Ringo
x2 = m.addVar(name="x2", lb=0)  # hours worked by John
x3 = m.addVar(name="x3", lb=0)  # hours worked by Mary

# Define the objective function
m.setObjective(5.51 * x0 + 6.01 * x1 + 3.55 * x2 + 3.47 * x3, gurobi.GRB.MAXIMIZE)

# Add constraints
# Individual ratings
m.addConstr(2 * x0 <= 152)
m.addConstr(14 * x0 <= 196)
m.addConstr(6 * x0 <= 194)
m.addConstr(11 * x1 <= 152)
m.addConstr(8 * x1 <= 196)
m.addConstr(13 * x1 <= 194)
m.addConstr(15 * x2 <= 152)
m.addConstr(x2 <= 196)
m.addConstr(14 * x2 <= 194)
m.addConstr(17 * x3 <= 152)
m.addConstr(23 * x3 <= 196)
m.addConstr(23 * x3 <= 194)

# Combined ratings
m.addConstr(2 * x0 + 11 * x1 >= 33)
m.addConstr(15 * x2 + 17 * x3 >= 21)
m.addConstr(11 * x1 + 17 * x3 >= 18)
m.addConstr(2 * x0 + 11 * x1 + 17 * x3 >= 29)
m.addConstr(2 * x0 + 11 * x1 + 15 * x2 >= 29)
m.addConstr(11 * x1 + 15 * x2 + 17 * x3 >= 29)
m.addConstr(2 * x0 + 11 * x1 + 17 * x3 >= 24)
m.addConstr(2 * x0 + 11 * x1 + 15 * x2 >= 24)
m.addConstr(11 * x1 + 15 * x2 + 17 * x3 >= 24)
m.addConstr(2 * x0 + 11 * x1 + 17 * x3 >= 21)
m.addConstr(2 * x0 + 11 * x1 + 15 * x2 >= 21)
m.addConstr(11 * x1 + 15 * x2 + 17 * x3 >= 21)
m.addConstr(8 * x1 + x2 + 23 * x3 >= 28)
m.addConstr(13 * x1 + 14 * x2 >= 18)
m.addConstr(6 * x0 + 23 * x3 >= 29)
m.addConstr(14 * x2 + 23 * x3 >= 32)
m.addConstr(6 * x0 + 14 * x2 + 23 * x3 >= 36)

# Upper bounds for combined ratings
m.addConstr(2 * x0 + 11 * x1 <= 83)
m.addConstr(15 * x2 + 17 * x3 <= 86)
m.addConstr(2 * x0 + 15 * x2 <= 147)
m.addConstr(11 * x1 + 17 * x3 <= 50)
m.addConstr(2 * x0 + 17 * x3 <= 67)
m.addConstr(2 * x0 + 11 * x1 + 15 * x2 + 17 * x3 <= 67)
m.addConstr(8 * x1 + x2 <= 185)
m.addConstr(x2 + 23 * x3 <= 85)
m.addConstr(8 * x1 + 23 * x3 <= 185)
m.addConstr(14 * x0 + x2 <= 142)
m.addConstr(14 * x0 + 8 * x1 <= 159)
m.addConstr(14 * x0 + 8 * x1 + x2 + 23 * x3 <= 159)
m.addConstr(14 * x2 + 23 * x3 <= 71)
m.addConstr(6 * x0 + 23 * x3 <= 178)
m.addConstr(6 * x0 + 14 * x2 <= 187)
m.addConstr(13 * x1 + 23 * x3 <= 136)
m.addConstr(6 * x0 + 13 * x1 <= 93)
m.addConstr(13 * x1 + 14 * x2 + 23 * x3 <= 127)
m.addConstr(6 * x0 + 13 * x1 + 14 * x2 <= 121)
m.addConstr(6 * x0 + 13 * x1 + 23 * x3 <= 58)
m.addConstr(6 * x0 + 13 * x1 + 14 * x2 + 23 * x3 <= 58)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("Hours worked by Hank: ", x0.varValue)
    print("Hours worked by Ringo: ", x1.varValue)
    print("Hours worked by John: ", x2.varValue)
    print("Hours worked by Mary: ", x3.varValue)
else:
    print("No optimal solution found")
