
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("resource_allocation")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="mechanized_infantry_companies")
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="water_purification_units")


    # Set objective function
    model.setObjective(8*x0 + 7*x1 + 4*x2, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11*x1 + 18*x2 >= 32, "mobility_constraint1")
    model.addConstr(7*x0 + 11*x1 >= 24, "mobility_constraint2")
    model.addConstr(7*x0 + 11*x1 + 18*x2 >= 24, "mobility_constraint3")
    model.addConstr(18*x1 + 3*x2 >= 26, "offensive_constraint1")
    model.addConstr(1*x0 + 18*x1 >= 12, "offensive_constraint2")
    model.addConstr(1*x0 + 18*x1 + 3*x2 >= 12, "offensive_constraint3")
    model.addConstr(7*x0 + 11*x1 + 18*x2 <= 49, "total_mobility_constraint")


    # Optimize model
    model.optimize()

    # Print results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {model.objVal}")
        print(f"CBRN platoons: {x0.x}")
        print(f"Mechanized infantry companies: {x1.x}")
        print(f"Water purification units: {x2.x}")
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
