
from gurobipy import *

# Create a new model
m = Model("Optimization_Model")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="CBRN_platoons")
x1 = m.addVar(vtype=GRB.INTEGER, name="mechanized_infantry_companies")
x2 = m.addVar(vtype=GRB.INTEGER, name="water_purification_units")

# Set the objective function
m.setObjective(8*x0 + 7*x1 + 4*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(11*x1 + 18*x2 >= 32, "mobility_rating_min_1")
m.addConstr(7*x0 + 11*x1 >= 24, "total_mobility_rating_min_1")
m.addConstr(7*x0 + 11*x1 + 18*x2 >= 24, "total_mobility_rating_min_all")
m.addConstr(18*x1 + 3*x2 >= 26, "offensive_capability_rating_min_1")
m.addConstr(1*x0 + 18*x1 >= 12, "offensive_capability_rating_min_2")
m.addConstr(1*x0 + 18*x1 + 3*x2 >= 12, "total_offensive_capability_rating_min_all")
m.addConstr(7*x0 + 11*x1 + 18*x2 <= 49, "total_mobility_rating_max")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"CBRN platoons: {x0.x}")
    print(f"Mechanized infantry companies: {x1.x}")
    print(f"Water purification units: {x2.x}")
else:
    print("No optimal solution found")
