
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
    x1 = model.addVar(name="mechanized_infantry_companies", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="water_purification_units", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(8 * x0 + 7 * x1 + 4 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11 * x1 + 18 * x2 >= 32)
    model.addConstr(7 * x0 + 11 * x1 >= 24)
    model.addConstr(7 * x0 + 11 * x1 + 18 * x2 >= 24)
    model.addConstr(18 * x1 + 3 * x2 >= 26)
    model.addConstr(x0 + 18 * x1 >= 12)
    model.addConstr(x0 + 18 * x1 + 3 * x2 >= 12)
    model.addConstr(7 * x0 + 11 * x1 + 18 * x2 <= 49)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"CBRN platoons: {x0.varValue}")
        print(f"Mechanized infantry companies: {x1.varValue}")
        print(f"Water purification units: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
