
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
ravioli = m.addVar(lb=0, name="ravioli")
black_beans = m.addVar(lb=0, name="black_beans")
cornichons = m.addVar(lb=0, name="cornichons")
apple_pies = m.addVar(lb=0, name="apple_pies")


# Set objective function
m.setObjective(6.22 * ravioli + 6.35 * black_beans + 7.57 * cornichons + 5.07 * apple_pies, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(25 * ravioli + 12 * black_beans >= 57)
m.addConstr(cornichons + 10 * apple_pies >= 56)
m.addConstr(12 * black_beans + 10 * apple_pies >= 101)
m.addConstr(25 * ravioli + 12 * black_beans + cornichons + 10 * apple_pies >= 101)
m.addConstr(8 * ravioli + 5 * apple_pies >= 104)
m.addConstr(25 * cornichons + 5 * apple_pies >= 82)
m.addConstr(8 * ravioli + 23 * black_beans >= 68)
m.addConstr(23 * black_beans + 25 * cornichons + 5 * apple_pies >= 117)
m.addConstr(8 * ravioli + 25 * cornichons + 5 * apple_pies >= 117)
m.addConstr(23 * black_beans + 25 * cornichons + 5 * apple_pies >= 86)
m.addConstr(8 * ravioli + 25 * cornichons + 5 * apple_pies >= 86)
m.addConstr(8 * ravioli + 23 * black_beans + 25 * cornichons + 5 * apple_pies >= 86)
m.addConstr(2 * ravioli + 5 * black_beans >= 75)
m.addConstr(19 * cornichons + 18 * apple_pies >= 52)
m.addConstr(5 * black_beans + 19 * cornichons >= 69)
m.addConstr(2 * ravioli + 18 * apple_pies >= 76)
m.addConstr(2 * ravioli + 19 * cornichons + 18 * apple_pies >= 90)
m.addConstr(2 * ravioli + 5 * black_beans + 19 * cornichons >= 90)
m.addConstr(5 * black_beans + 19 * cornichons + 18 * apple_pies >= 90)
m.addConstr(2 * ravioli + 19 * cornichons + 18 * apple_pies >= 80)
m.addConstr(2 * ravioli + 5 * black_beans + 19 * cornichons >= 80)
m.addConstr(5 * black_beans + 19 * cornichons + 18 * apple_pies >= 80)
m.addConstr(2 * ravioli + 19 * cornichons + 18 * apple_pies >= 55)
m.addConstr(2 * ravioli + 5 * black_beans + 19 * cornichons >= 55)
m.addConstr(5 * black_beans + 19 * cornichons + 18 * apple_pies >= 55)
m.addConstr(2 * ravioli + 5 * black_beans + 19 * cornichons + 18 * apple_pies >= 55)
m.addConstr(3 * ravioli - 10 * apple_pies >= 0)
m.addConstr(-black_beans + 8 * cornichons >= 0)
m.addConstr(6 * ravioli - 7 * black_beans >= 0)
m.addConstr(12 * black_beans + cornichons <= 568)
m.addConstr(25 * ravioli + 12 * black_beans + cornichons <= 517)
m.addConstr(25 * cornichons + 5 * apple_pies <= 126)
m.addConstr(8 * ravioli + 5 * apple_pies <= 130)
m.addConstr(8 * ravioli + 23 * black_beans <= 446)
m.addConstr(23 * black_beans + 5 * apple_pies <= 261)
m.addConstr(8 * ravioli + 25 * cornichons <= 320)
m.addConstr(19 * cornichons + 18 * apple_pies <= 320)
m.addConstr(2 * ravioli + 18 * apple_pies <= 91)
m.addConstr(5 * black_beans + 18 * apple_pies <= 92)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

