
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="ravioli", lb=0)
x1 = model.addVar(name="black_beans", lb=0)
x2 = model.addVar(name="cornichons", lb=0)
x3 = model.addVar(name="apple_pies", lb=0)

# Objective function
model.setObjective(6.22 * x0 + 6.35 * x1 + 7.57 * x2 + 5.07 * x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(25 * x0 + 12 * x1 >= 57)
model.addConstr(x2 + 10 * x3 >= 56)
model.addConstr(12 * x1 + 10 * x3 >= 101)
model.addConstr(25 * x0 + 12 * x1 + x2 + 10 * x3 >= 101)
model.addConstr(8 * x0 + 5 * x3 >= 104)
model.addConstr(25 * x2 + 5 * x3 >= 82)
model.addConstr(8 * x0 + 23 * x1 >= 68)
model.addConstr(23 * x1 + 25 * x2 + 5 * x3 >= 117)
model.addConstr(8 * x0 + 25 * x2 + 5 * x3 >= 117)
model.addConstr(8 * x0 + 23 * x1 + 25 * x2 + 5 * x3 >= 86)
model.addConstr(2 * x0 + 5 * x1 >= 75)
model.addConstr(19 * x2 + 18 * x3 >= 52)
model.addConstr(5 * x1 + 19 * x2 >= 69)
model.addConstr(2 * x0 + 18 * x3 >= 76)
model.addConstr(2 * x0 + 19 * x2 + 18 * x3 >= 90)
model.addConstr(2 * x0 + 5 * x1 + 19 * x2 >= 90)
model.addConstr(5 * x1 + 19 * x2 + 18 * x3 >= 90)
model.addConstr(2 * x0 + 19 * x2 + 18 * x3 >= 80)
model.addConstr(2 * x0 + 5 * x1 + 19 * x2 >= 80)
model.addConstr(5 * x1 + 19 * x2 + 18 * x3 >= 80)
model.addConstr(2 * x0 + 19 * x2 + 18 * x3 >= 55)
model.addConstr(2 * x0 + 5 * x1 + 19 * x2 >= 55)
model.addConstr(5 * x1 + 19 * x2 + 18 * x3 >= 55)
model.addConstr(2 * x0 + 5 * x1 + 19 * x2 + 18 * x3 >= 55)
model.addConstr(3 * x0 - 10 * x3 >= 0)
model.addConstr(-x1 + 8 * x2 >= 0)
model.addConstr(6 * x0 - 7 * x1 >= 0)
model.addConstr(12 * x1 + x2 <= 568)
model.addConstr(25 * x0 + 12 * x1 + x2 <= 517)
model.addConstr(25 * x2 + 5 * x3 <= 126)
model.addConstr(8 * x0 + 5 * x3 <= 130)
model.addConstr(8 * x0 + 23 * x1 <= 446)
model.addConstr(23 * x1 + 5 * x3 <= 261)
model.addConstr(8 * x0 + 25 * x2 <= 320)
model.addConstr(19 * x2 + 18 * x3 <= 320)
model.addConstr(2 * x0 + 18 * x3 <= 91)
model.addConstr(5 * x1 + 18 * x3 <= 92)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Ravioli: ", x0.varValue)
    print("Black Beans: ", x1.varValue)
    print("Cornichons: ", x2.varValue)
    print("Apple Pies: ", x3.varValue)
else:
    print("The model is infeasible")
