
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B1
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin B4
    x2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # grams of protein


    # Set objective function
    model.setObjective(9.32 * x0 + 7.5 * x1 + 2.63 * x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16 * x0 + 23 * x2 >= 25, "c0")
    model.addConstr(6 * x1 + 23 * x2 >= 23, "c1")
    model.addConstr(16 * x0 + 6 * x1 <= 143, "c2")
    model.addConstr(6 * x1 + 23 * x2 <= 74, "c3")
    model.addConstr(16 * x0 + 23 * x2 <= 77, "c4")
    model.addConstr(16 * x0 + 6 * x1 + 23 * x2 <= 77, "c5")
    model.addConstr(25 * x1 + 6 * x2 <= 232, "c6")
    model.addConstr(4 * x0 + 25 * x1 <= 171, "c7")
    model.addConstr(4 * x0 + 25 * x1 + 6 * x2 <= 171, "c8")
    model.addConstr(17 * x0 + 5 * x2 <= 40, "c9")
    model.addConstr(17 * x0 + 26 * x1 + 5 * x2 <= 40, "c10")
    model.addConstr(11 * x0 + 4 * x1 <= 58, "c11")
    model.addConstr(11 * x0 + 1 * x2 <= 49, "c12")
    model.addConstr(11 * x0 + 4 * x1 + 1 * x2 <= 49, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
