
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B1
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B4
    x3 = model.addVar(name="x3", lb=0)  # grams of protein

    # Define the objective function
    model.setObjective(9.32 * x1 + 7.5 * x2 + 2.63 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(16 * x1 <= 212)
    model.addConstr(4 * x1 <= 417)
    model.addConstr(17 * x1 <= 105)
    model.addConstr(11 * x1 <= 107)
    model.addConstr(6 * x2 <= 212)
    model.addConstr(25 * x2 <= 417)
    model.addConstr(26 * x2 <= 105)
    model.addConstr(4 * x2 <= 107)
    model.addConstr(23 * x3 <= 212)
    model.addConstr(6 * x3 <= 417)
    model.addConstr(5 * x3 <= 105)
    model.addConstr(1 * x3 <= 107)
    model.addConstr(16 * x1 + 23 * x3 >= 25)
    model.addConstr(6 * x2 + 23 * x3 >= 23)
    model.addConstr(16 * x1 + 6 * x2 <= 143)
    model.addConstr(6 * x2 + 23 * x3 <= 74)
    model.addConstr(16 * x1 + 23 * x3 <= 77)
    model.addConstr(16 * x1 + 6 * x2 + 23 * x3 <= 77)
    model.addConstr(25 * x2 + 6 * x3 <= 232)
    model.addConstr(4 * x1 + 25 * x2 <= 171)
    model.addConstr(4 * x1 + 25 * x2 + 6 * x3 <= 171)
    model.addConstr(17 * x1 + 5 * x3 <= 40)
    model.addConstr(17 * x1 + 26 * x2 + 5 * x3 <= 40)
    model.addConstr(11 * x1 + 4 * x2 <= 58)
    model.addConstr(11 * x1 + 1 * x3 <= 49)
    model.addConstr(11 * x1 + 4 * x2 + 1 * x3 <= 49)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B1: {x1.varValue}")
        print(f"Milligrams of vitamin B4: {x2.varValue}")
        print(f"Grams of protein: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
