
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    pasta = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pasta")
    fruit_salad = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salad")
    steak = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steak")


    # Set objective function
    m.setObjective(3.52 * pasta + 4.21 * fruit_salad + 7.54 * steak, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(fruit_salad + steak >= 37, "fat_constraint1")
    m.addConstr(pasta + steak >= 41, "fat_constraint2")
    m.addConstr(fruit_salad + steak >= 11, "taste_constraint1")
    m.addConstr(pasta + steak >= 12, "taste_constraint2")
    m.addConstr(-6 * pasta + 3 * fruit_salad >= 0, "pasta_fruit_constraint")
    m.addConstr(10 * pasta + 2 * steak <= 174, "fat_constraint3")
    m.addConstr(10 * pasta + 1 * fruit_salad + 2 * steak <= 161, "fat_constraint4")
    m.addConstr(1 * fruit_salad + 1 * steak <= 36, "taste_constraint3")
    m.addConstr(8 * pasta + 1 * fruit_salad <= 17, "taste_constraint4")
    m.addConstr(8 * pasta + 1 * fruit_salad + 1 * steak <= 17, "taste_constraint5")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('pasta:', pasta.x)
        print('fruit_salad:', fruit_salad.x)
        print('steak:', steak.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
