
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="bowls_of_pasta", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x1 = m.addVar(name="fruit_salads", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="steaks", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
m.setObjective(3.52 * x0 + 4.21 * x1 + 7.54 * x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(10 * x0 + 1 * x1 + 2 * x2 <= 215)
m.addConstr(8 * x0 + 1 * x1 + 1 * x2 <= 45)
m.addConstr(1 * x1 + 2 * x2 >= 37)
m.addConstr(10 * x0 + 2 * x2 >= 41)
m.addConstr(1 * x1 + 1 * x2 >= 11)
m.addConstr(8 * x0 + 1 * x2 >= 12)
m.addConstr(-6 * x0 + 3 * x1 >= 0)
m.addConstr(10 * x0 + 2 * x2 <= 174)
m.addConstr(10 * x0 + 1 * x1 + 2 * x2 <= 161)
m.addConstr(1 * x1 + 1 * x2 <= 36)
m.addConstr(8 * x0 + 1 * x1 <= 17)
m.addConstr(8 * x0 + 1 * x1 + 1 * x2 <= 17)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bowls of pasta: ", x0.varValue)
    print("fruit salads: ", x1.varValue)
    print("steaks: ", x2.varValue)
else:
    print("The model is infeasible")
