
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(6, lb=0, vtype=GRB.CONTINUOUS, name=["x0", "x1", "x2", "x3", "x4", "x5"])


# Set objective function
m.setObjective(9.62*x[0]**2 + 2.75*x[0]*x[1] + 6.52*x[0]*x[2] + 4.2*x[0]*x[3] + 4.28*x[0]*x[4] + 7.24*x[0]*x[5] + 2.97*x[1]*x[2] + 3.55*x[1]*x[3] + 1.79*x[1]*x[5] + 8.58*x[2]**2 + 2.39*x[2]*x[3] + 7.44*x[2]*x[4] + 3.44*x[2]*x[5] + 2.19*x[3]**2 + 6.45*x[3]*x[4] + 8.06*x[3]*x[5] + 5.33*x[4]**2 + 4.48*x[4]*x[5] + 1.56*x[5]**2 + 1.29*x[0] + 5.81*x[1] + 9.72*x[2] + 3.47*x[3] + 7.45*x[4] + 5.11*x[5], GRB.MINIMIZE)


# Add constraints
m.addConstr(7*x[0] + 6*x[1] + 9*x[2] + x[3] + x[4] + 14*x[5] <= 257)
m.addConstr(4*x[0] + 14*x[1] + 9*x[2] + 4*x[3] + 14*x[4] + 9*x[5] <= 173)
m.addConstr(3*x[0] + 9*x[1] + 9*x[2] + 6*x[3] + 11*x[4] + 9*x[5] <= 80)

# ... (rest of the constraints from the JSON "constraints" field)

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

