 
import gurobi as gp

m = gp.Model()

x0 = m.addVar(lb=0, name="bowls_of_instant_ramen")
x1 = m.addVar(lb=0, name="cantaloupes")
x2 = m.addVar(lb=0, name="chicken_drumsticks")
x3 = m.addVar(lb=0, name="bowls_of_cereal")
x4 = m.addVar(lb=0, name="chicken_breasts")
x5 = m.addVar(lb=0, name="rotisserie_chickens")

obj = 9.62*x0**2 + 2.75*x0*x1 + 6.52*x0*x2 + 4.2*x0*x3 + 4.28*x0*x4 + 7.24*x0*x5 + \
      2.97*x1*x2 + 3.55*x1*x3 + 1.79*x1*x5 + 8.58*x2**2 + 2.39*x2*x3 + 7.44*x2*x4 + \
      3.44*x2*x5 + 2.19*x3**2 + 6.45*x3*x4 + 8.06*x3*x5 + 5.33*x4**2 + 4.48*x4*x5 + \
      1.56*x5**2 + 1.29*x0 + 5.81*x1 + 9.72*x2 + 3.47*x3 + 7.45*x4 + 5.11*x5

m.setObjective(obj, gp.GRB.MINIMIZE)

m.addConstr(7*x0 + 6*x1 + 9*x2 + 1*x3 + 1*x4 + 14*x5 <= 257)
m.addConstr(4*x0 + 14*x1 + 9*x2 + 4*x3 + 14*x4 + 9*x5 <= 173)
m.addConstr(3*x0 + 9*x1 + 9*x2 + 6*x3 + 11*x4 + 9*x5 <= 80)

# Add the rest of your constraints here

m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("bowls_of_instant_ramen: ", x0.varValue)
    print("cantaloupes: ", x1.varValue)
    print("chicken_drumsticks: ", x2.varValue)
    print("bowls_of_cereal: ", x3.varValue)
    print("chicken_breasts: ", x4.varValue)
    print("rotisserie_chickens: ", x5.varValue)
else:
    print("No optimal solution found")
