
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
peanutbutter_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")
strips_of_bacon = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")

# Set objective function
m.setObjective(8.3 * green_beans + 8.2 * peanutbutter_sandwiches + 7.13 * cornichons + 4.73 * strips_of_bacon, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(18 * green_beans + 9 * peanutbutter_sandwiches + 5 * cornichons + 13 * strips_of_bacon <= 501, "c0")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 5 * cornichons + 22 * strips_of_bacon <= 251, "c1")
m.addConstr(9 * green_beans + 1 * peanutbutter_sandwiches + 4 * cornichons + 2 * strips_of_bacon <= 180, "c2")
m.addConstr(9 * peanutbutter_sandwiches + 13 * strips_of_bacon >= 54, "c3")
m.addConstr(5 * cornichons + 13 * strips_of_bacon >= 102, "c4")
m.addConstr(18 * green_beans + 13 * strips_of_bacon >= 70, "c5")
m.addConstr(18 * green_beans + 9 * peanutbutter_sandwiches >= 76, "c6")
m.addConstr(9 * peanutbutter_sandwiches + 5 * cornichons >= 96, "c7")
m.addConstr(18 * green_beans + 5 * cornichons >= 72, "c8")
m.addConstr(18 * green_beans + 9 * peanutbutter_sandwiches + 5 * cornichons >= 125, "c9")
m.addConstr(9 * peanutbutter_sandwiches + 5 * cornichons + 13 * strips_of_bacon >= 125, "c10")
m.addConstr(18 * green_beans + 5 * cornichons + 13 * strips_of_bacon >= 125, "c11")
m.addConstr(18 * green_beans + 9 * peanutbutter_sandwiches + 5 * cornichons >= 64, "c12")
m.addConstr(9 * peanutbutter_sandwiches + 5 * cornichons + 13 * strips_of_bacon >= 64, "c13")
m.addConstr(18 * green_beans + 5 * cornichons + 13 * strips_of_bacon >= 64, "c14")
m.addConstr(18 * green_beans + 9 * peanutbutter_sandwiches + 5 * cornichons >= 90, "c15")
m.addConstr(9 * peanutbutter_sandwiches + 5 * cornichons + 13 * strips_of_bacon >= 90, "c16")
m.addConstr(18 * green_beans + 5 * cornichons + 13 * strips_of_bacon >= 90, "c17")
m.addConstr(18 * green_beans + 9 * peanutbutter_sandwiches + 5 * cornichons + 13 * strips_of_bacon >= 90, "c18")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches >= 44, "c19")
m.addConstr(22 * green_beans + 5 * cornichons >= 41, "c20")
m.addConstr(5 * cornichons + 22 * strips_of_bacon >= 62, "c21")
m.addConstr(16 * peanutbutter_sandwiches + 22 * strips_of_bacon >= 34, "c22")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 22 * strips_of_bacon >= 34, "c23")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 5 * cornichons >= 34, "c24")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 22 * strips_of_bacon >= 31, "c25")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 5 * cornichons >= 31, "c26")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 5 * cornichons + 22 * strips_of_bacon >= 31, "c27")
m.addConstr(1 * peanutbutter_sandwiches + 2 * strips_of_bacon >= 26, "c28")
m.addConstr(9 * green_beans + 4 * cornichons >= 29, "c29")
m.addConstr(4 * cornichons + 2 * strips_of_bacon >= 18, "c30")
m.addConstr(9 * green_beans + 1 * peanutbutter_sandwiches + 4 * cornichons + 2 * strips_of_bacon >= 18, "c31")
m.addConstr(18 * green_beans + 5 * cornichons + 13 * strips_of_bacon <= 250, "c32")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches <= 117, "c33")
m.addConstr(22 * green_beans + 5 * cornichons <= 219, "c34")
m.addConstr(16 * peanutbutter_sandwiches + 22 * strips_of_bacon <= 181, "c35")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 5 * cornichons <= 246, "c36")
m.addConstr(16 * peanutbutter_sandwiches + 5 * cornichons + 22 * strips_of_bacon <= 113, "c37")
m.addConstr(22 * green_beans + 16 * peanutbutter_sandwiches + 22 * strips_of_bacon <= 224, "c38")
m.addConstr(9 * green_beans + peanutbutter_sandwiches <= 142, "c39")
m.addConstr(9 * green_beans + 4 * cornichons <= 91, "c40")
m.addConstr(9 * green_beans + 2 * strips_of_bacon <= 112, "c41")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

