
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin E
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # grams of fat
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B12
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin B5


    # Set objective function
    m.setObjective(2.98*x0 + 1.63*x1 + 4.26*x2 + 5.28*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5.37*x2 + 5.67*x3 >= 24)
    m.addConstr(1.74*x1 + 5.67*x3 >= 28)
    m.addConstr(5.34*x0 + 5.37*x2 >= 45)
    m.addConstr(1.74*x1 + 5.37*x2 >= 34)
    m.addConstr(5.34*x0 + 1.74*x1 >= 19)
    m.addConstr(7.87*x0 + 7.55*x2 >= 22)
    m.addConstr(5.37*x2 + 5.67*x3 <= 85)
    m.addConstr(5.34*x0 + 5.37*x2 <= 142)
    m.addConstr(5.34*x0 + 1.74*x1 <= 68)
    m.addConstr(5.34*x0 + 1.74*x1 + 5.67*x3 <= 67)
    m.addConstr(1.74*x1 + 5.37*x2 + 5.67*x3 <= 188)
    m.addConstr(5.34*x0 + 1.74*x1 + 5.37*x2 + 5.67*x3 <= 188)
    m.addConstr(7.87*x0 + 1.17*x1 <= 70)
    m.addConstr(1.17*x1 + 10.79*x3 <= 194)
    m.addConstr(7.87*x0 + 1.17*x1 + 10.79*x3 <= 249)
    m.addConstr(7.87*x0 + 1.17*x1 + 7.55*x2 <= 194)
    m.addConstr(7.87*x0 + 7.55*x2 + 10.79*x3 <= 204)
    m.addConstr(7.87*x0 + 1.17*x1 + 7.55*x2 + 10.79*x3 <= 204)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
