
import gurobipy as gp

# Create a new model
m = gp.Model("pie_sandwich_optimization")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="blueberry pies")
x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="cherry pies")
x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="peanutbutter sandwiches")


# Set objective function
m.setObjective(4.12 * x0 + 5.17 * x1 + 3.44 * x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4.51 * x0 <= 135, "blueberry pie cost")
m.addConstr(4.11 * x1 + 13.38 * x2 <= 135, "cherry pie and sandwich cost")
m.addConstr(4.51 * x0 + 4.11 * x1 + 13.38 * x2 <= 214, "total cost")
m.addConstr(14.6 * x0 + 7.36 * x2 <= 256, "blueberry pie and sandwich calcium")
m.addConstr(8.51 * x1 + 7.36 * x2 <= 282, "cherry pie and sandwich calcium constraint")
m.addConstr(14.6 * x0 + 8.51 * x1 + 7.36 * x2 <= 314, "total calcium")
m.addConstr(8.51 * x1 + 7.36 * x2 >= 77, "min cherry pie and sandwich calcium")
m.addConstr(-5 * x0 + 7 * x1 >= 0, "blueberry and cherry pie ratio")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('blueberry pies:', x0.x)
    print('cherry pies:', x1.x)
    print('peanutbutter sandwiches:', x2.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

