
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="blueberry_pies", lb=0, ub=None)  # Can be fractional
    x1 = model.addVar(name="cherry_pies", lb=0, integer=True)  # Must be an integer
    x2 = model.addVar(name="peanutbutter_sandwiches", lb=0, integer=True)  # Must be an integer

    # Objective function
    model.setObjective(4.12 * x0 + 5.17 * x1 + 3.44 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4.51 * x0 <= 214)  # Dollar cost constraint for blueberry pies
    model.addConstr(14.6 * x0 <= 314)  # Calcium constraint for blueberry pies
    model.addConstr(8.51 * x1 + 7.36 * x2 >= 77)  # Calcium from cherry pies and peanutbutter sandwiches
    model.addConstr(-5 * x0 + 7 * x1 >= 0)  # Relationship between blueberry pies and cherry pies
    model.addConstr(4.11 * x1 + 13.38 * x2 <= 135)  # Budget for cherry pies and peanutbutter sandwiches
    model.addConstr(4.51 * x0 + 4.11 * x1 + 13.38 * x2 <= 214)  # Total budget constraint
    model.addConstr(14.6 * x0 + 7.36 * x2 <= 256)  # Calcium from blueberry pies and peanutbutter sandwiches
    model.addConstr(8.51 * x1 + 7.36 * x2 <= 282)  # Calcium from cherry pies and peanutbutter sandwiches
    model.addConstr(14.6 * x0 + 8.51 * x1 + 7.36 * x2 <= 282)  # Total calcium constraint

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Blueberry pies: ", x0.varValue)
        print("Cherry pies: ", x1.varValue)
        print("Peanutbutter sandwiches: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
