
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.INTEGER, name="x0") # Mbps bandwidth allocated to monitoring
    x1 = model.addVar(vtype=gp.GRB.INTEGER, name="x1") # automatic alerts
    x2 = model.addVar(vtype=gp.GRB.INTEGER, name="x2") # network administrators
    x3 = model.addVar(vtype=gp.GRB.INTEGER, name="x3") # deployed decoys


    # Set objective function
    model.setObjective(5.2 * x0 + 5.57 * x1 + 9.85 * x2 + 4.94 * x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4.81 * x0 + 2.43 * x1 + 3.8 * x2 + 1.36 * x3 <= 50, "c0")
    model.addConstr(3.7 * x0 + 3.39 * x1 + 3.4 * x2 + 4.51 * x3 <= 120, "c1")
    model.addConstr(4.81 * x0 + 3.8 * x2 >= 10, "c2")
    model.addConstr(2.43 * x1 + 1.36 * x3 >= 4, "c3")
    model.addConstr(4.81 * x0 + 2.43 * x1 >= 5, "c4")
    model.addConstr(3.8 * x2 + 1.36 * x3 >= 12, "c5")
    model.addConstr(4.81 * x0 + 2.43 * x1 + 3.8 * x2 + 1.36 * x3 >= 12, "c6")
    model.addConstr(3.39 * x1 + 4.51 * x3 >= 15, "c7")
    model.addConstr(3.7 * x0 + 3.4 * x2 >= 28, "c8")
    model.addConstr(3.4 * x2 + 4.51 * x3 >= 11, "c9")
    model.addConstr(3.7 * x0 + 4.51 * x3 >= 13, "c10")
    model.addConstr(3.7 * x0 + 3.39 * x1 >= 17, "c11")
    model.addConstr(3.7 * x0 + 3.4 * x2 + 4.51 * x3 >= 18, "c12")
    model.addConstr(3.7 * x0 + 3.39 * x1 + 3.4 * x2 + 4.51 * x3 >= 18, "c13")
    model.addConstr(6 * x0 - 2 * x3 >= 0, "c14")
    model.addConstr(4 * x1 - x3 >= 0, "c15")
    model.addConstr(2.43 * x1 + 1.36 * x3 <= 46, "c16")
    model.addConstr(4.81 * x0 + 1.36 * x3 <= 42, "c17")
    model.addConstr(3.8 * x2 + 1.36 * x3 <= 45, "c18")
    model.addConstr(4.81 * x0 + 2.43 * x1 + 3.8 * x2 <= 45, "c19")
    model.addConstr(4.81 * x0 + 2.43 * x1 + 1.36 * x3 <= 44, "c20")
    model.addConstr(3.39 * x1 + 3.4 * x2 <= 90, "c21")
    model.addConstr(3.7 * x0 + 3.39 * x1 <= 78, "c22")
    model.addConstr(3.4 * x2 + 4.51 * x3 <= 90, "c23")
    model.addConstr(3.39 * x1 + 4.51 * x3 <= 102, "c24")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
